package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class BoolParserFormatter extends ParserFormatter<Boolean> {
    private final String t;
    private final String f;

    BoolParserFormatter(String t, String f) {
        this.t = t;
        this.f = f;
    }

    @Override
    public String format(Boolean aBoolean) {
        return aBoolean ? t : f;
    }

    @Override
    public Result<Boolean> parsePrefix(String string) {
        if (string.startsWith(t)) {
            return new Success<>(true, string.substring(t.length()));
        } else if (string.startsWith(f)) {
            return new Success<>(false, string.substring(f.length()));
        } else {
            return new Failure<>();
        }
    }

    @Override
    public String toString() {
        return "bool(" + t + "|" + f + ")";
    }
}
