package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class FixedLengthParserFormatter extends ParserFormatter<String> {
    private final int length;

    FixedLengthParserFormatter(int length) {
        this.length = length;
    }

    @Override
    public String format(String s) {
        if (s.length() != length) {
            throw new IllegalStateException("string must be of length " + length + ": " + s);
        }
        return s;
    }

    @Override
    public Result<String> parsePrefix(String string) {
        if (string.length() >= length) {
            return new Success<>(string.substring(0, length), string.substring(length));
        } else {
            return new Failure<>();
        }
    }

    @Override
    public String toString() {
        return "length(" + length + ")";
    }
}
