package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class MapParserFormatter<A, B> extends ParserFormatter<B> {
    private final ParserFormatter<A> source;
    private final TwoWayFunction<A, B> f;

    MapParserFormatter(ParserFormatter<A> source, TwoWayFunction<A, B> f) {
        this.source = source;
        this.f = f;
    }

    @Override
    public String format(B b) {
        return source.format(f.backwards(b));
    }

    @Override
    public Result<B> parsePrefix(String string) {
        return source.parsePrefix(string).map(f::thatWay);
    }

    @Override
    public String toString() {
        return source.toString();
    }
}
