package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.server.data.names.NumberNamePart;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class NumberParserFormatter extends ParserFormatter<Long> {
    private final NumberNamePart p;

    NumberParserFormatter(NumberNamePart p) {
        this.p = p;
    }

    @Override
    public String format(Long aLong) {
        return p.format(aLong);
    }

    @Override
    public Result<Long> parsePrefix(String string) {
        if (string.length() < p.getDigitCount()) {
            return new Failure<>();
        }

        long l = Long.parseUnsignedLong(string.substring(0, p.getDigitCount()), 10);

        return new Success<>(l, string.substring(p.getDigitCount()));
    }

    @Override
    public String toString() {
        return "number{" + p.getDigitCount() + "}";
    }
}
