package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Tuple2;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class PairParserFormatter<A, B> extends ParserFormatter<Tuple2<A, B>> {
    private final ParserFormatter<A> a;
    private final ParserFormatter<B> b;

    public PairParserFormatter(ParserFormatter<A> a, ParserFormatter<B> b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public String format(Tuple2<A, B> abTuple2) {
        return a.format(abTuple2._1) + b.format(abTuple2._2);
    }

    @Override
    public Result<Tuple2<A, B>> parsePrefix(String string) {
        return a.parsePrefix(string).thenParse((av, arem) -> {
            return b.parsePrefix(arem).thenParse((bv, brem) -> {
                return new Success<>(Tuple2.tuple(av, bv), brem);
            });
        });
    }

    @Override
    public String toString() {
        return a + " + " + b;
    }
}
