package ru.yandex.stockpile.server.data.names.parserFormatter;

/**
 * @author Vladimir Gordiychuk
 */
public class ParserAsParserFormatter<T> extends ParserFormatter<T> {
    private final Parser<T> parser;

    public ParserAsParserFormatter(Parser<T> parser) {
        this.parser = parser;
    }

    public static <T> ParserFormatter<T> of(Parser<T> pf) {
        if (pf instanceof ParserAsParserFormatter) {
            return (ParserFormatter<T>) pf;
        }

        return new ParserAsParserFormatter<>(pf);
    }

    @Override
    public String format(T a) {
        throw new IllegalStateException("not a formatter");
    }

    @Override
    public Result<T> parsePrefix(String string) {
        return parser.parsePrefix(string);
    }

    @Override
    public String toString() {
        return parser.toString();
    }
}
