package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class ParserFormatter<A> implements Parser<A> {

    public abstract String format(A a);

    public <B> ParserFormatter<B> map(TwoWayFunction<A, B> f) {
        return new MapParserFormatter<>(this, f);
    }

    @Override
    public ParserFormatter<A> addPrefix(ParserFormatter<Void> prefix) {
        return ParserFormatters.seq2(prefix, this).map(new PrefixFn<>());
    }

    @Override
    public ParserFormatter<A> addPrefix(String prefix) {
        return addPrefix(ParserFormatters.str(prefix));
    }

    public ParserFormatter<A> addSuffix(ParserFormatter<Void> suffix) {
        return ParserFormatters.seq2(this, suffix).map(new SuffixFn<>());
    }

    public ParserFormatter<A> addSuffix(String suffix) {
        return addSuffix(ParserFormatters.str(suffix));
    }
}
