package ru.yandex.stockpile.server.data.names.parserFormatter;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.stockpile.server.data.names.NumberNamePart;

/**
 * @author Vladimir Gordiychuk
 */
public class ParserFormatters {
    public static ParserFormatter<Void> str(String string) {
        return new StringParserFormatter(string);
    }

    public static ParserFormatter<String> fixedLengthString(int length) {
        return new FixedLengthParserFormatter(length);
    }

    public static ParserFormatter<Boolean> bool(String t, String f) {
        return new BoolParserFormatter(t, f);
    }

    public static ParserFormatter<Long> numberPart(NumberNamePart p) {
        return new NumberParserFormatter(p);
    }

    public static <A, B> ParserFormatter<Tuple2<A, B>> seq2(ParserFormatter<A> a, ParserFormatter<B> b) {
        return new PairParserFormatter<>(a, b);
    }
}
