package ru.yandex.stockpile.server.data.names.parserFormatter;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class StringParserFormatter extends ParserFormatter<Void> {
    private final String string;

    public StringParserFormatter(String string) {
        this.string = string;
    }

    @Override
    public String format(Void aVoid) {
        return string;
    }

    @Override
    public Result<Void> parsePrefix(String s) {
        if (s.startsWith(string)) {
            return new Success<>(null, s.substring(string.length()));
        } else {
            return new Failure<>();
        }
    }

    @Override
    public String toString() {
        return "\"" + string + "\"";
    }
}
