package ru.yandex.stockpile.server.shard;

import ru.yandex.misc.lang.DefaultToString;
import ru.yandex.solomon.config.protobuf.stockpile.EInvalidArchiveStrategy;
import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.annotations.ManagerMethod;

/**
 * @author Vladimir Gordiychuk
 */
@LinkedOnRootPage("Invalid Archive Strategy")
public class InvalidArchiveStrategy extends DefaultToString {
    public EInvalidArchiveStrategy strategy;

    public InvalidArchiveStrategy(EInvalidArchiveStrategy strategy) {
        this.strategy = strategy;
    }

    @ManagerMethod
    public void changeStrategy(EInvalidArchiveStrategy strategy) {
        this.strategy = strategy;
    }

    public static InvalidArchiveStrategy fail() {
        return new InvalidArchiveStrategy(EInvalidArchiveStrategy.FAIL);
    }
}
