package ru.yandex.stockpile.server.shard;

import org.springframework.stereotype.Component;

import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.annotations.ManagerMethod;

/**
 * @author Vladimir Gordiychuk
 */
@Component
@LinkedOnRootPage("LogStateOptions")
public class LogStateOptions {
    static volatile long FILES_COUNT = 100;

    @ManagerMethod
    public void setFilesCount(long count) {
        FILES_COUNT = count;
    }

    @Override
    public String toString() {
        return "LogStateOptions{fileCount=" + FILES_COUNT + "}";
    }
}
