package ru.yandex.stockpile.server.shard;

import java.util.Arrays;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.solomon.util.time.DurationUtils;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;

/**
 * @author Vladimir Gordiychuk
 */
public class MergeAdvice implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(MergeAdvice.class);

    public final SnapshotIndex[] indexes;
    public final boolean allowDelete;
    public final boolean allowDecim;
    public final long splitDelayMillis;

    public MergeAdvice(SnapshotIndex[] indexes, boolean allowDelete, boolean allowDecim, long splitDelayMillis) {
        this.indexes = indexes;
        this.allowDelete = allowDelete;
        this.allowDecim = allowDecim;
        this.splitDelayMillis = splitDelayMillis;
    }

    @Override
    public String toString() {
        return "MergeAdvice{" +
            "indexes=" + Arrays.toString(indexes) +
            ", allowDelete=" + allowDelete +
            ", allowDecim=" + allowDecim +
            ", splitDelay=" + DurationUtils.formatDurationMillis(splitDelayMillis) +
            '}';
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + MemoryCounter.arrayObjectSize(indexes);
    }
}
