package ru.yandex.stockpile.server.shard;

import ru.yandex.stockpile.memState.MetricIdAndData;
import ru.yandex.stockpile.server.data.DeletedShardSet;

/**
 * @author Vladimir Gordiychuk
 */
public class MergeDeletedShardFilter extends ProxyProcessor<MetricIdAndData, MetricIdAndData> {
    private final DeletedShardSet deletedShards;

    public MergeDeletedShardFilter(DeletedShardSet deletedShard) {
        this.deletedShards = deletedShard;
    }

    @Override
    public void onNext(MetricIdAndData item) {
        if (isShardDeleted(item)) {
            subscription.request(1);
            return;
        }

        subscriber.onNext(item);
    }

    private boolean isShardDeleted(MetricIdAndData metrics) {
        var archive = metrics.archive();
        return deletedShards.contains(archive.getOwnerProjectId(), archive.getOwnerShardId());
    }
}
