package ru.yandex.stockpile.server.shard;

import java.util.function.Function;

import ru.yandex.solomon.codec.archive.header.DeleteBeforeField;
import ru.yandex.stockpile.memState.MetricIdAndData;

/**
 * @author Vladimir Gordiychuk
 */
public class MergeFilter extends ProxyProcessor<MergeTaskResult, MetricIdAndData> {
    private final Function<MergeTaskResult, MetricIdAndData> fn;
    private final boolean allowDelete;

    public MergeFilter(Function<MergeTaskResult, MetricIdAndData> fn, boolean allowDelete) {
        this.fn = fn;
        this.allowDelete = allowDelete;
    }

    @Override
    public void onNext(MergeTaskResult item) {
        var merged = fn.apply(item);
        if (merged == null) {
            subscription.request(1);
            return;
        }

        var archive = merged.archive();
        if (archive.isEmpty() && allowDelete && archive.getDeleteBefore() != DeleteBeforeField.KEEP) {
            subscription.request(1);
            archive.close();
            return;
        }

        subscriber.onNext(merged);
    }
}
