package ru.yandex.stockpile.server.shard;

import java.util.EnumSet;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.server.SnapshotLevel;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum MergeKind {
    DAILY(ProcessType.DAILY_MERGE, SnapshotLevel.DAILY, EnumSet.of(SnapshotLevel.TWO_HOURS, SnapshotLevel.DAILY)),
    ETERNITY(ProcessType.ETERNITY_MERGE, SnapshotLevel.ETERNITY, EnumSet.allOf(SnapshotLevel.class)),
    ;

    public final ProcessType processType;
    public final SnapshotLevel targetLevel;
    private final EnumSet<SnapshotLevel> readLevels;

    MergeKind(ProcessType processType, SnapshotLevel targetLevel, EnumSet<SnapshotLevel> readLevels) {
        this.processType = processType;
        this.targetLevel = targetLevel;
        this.readLevels = readLevels;
    }

    public EnumSet<SnapshotLevel> readLevels() {
        return EnumSet.copyOf(readLevels);
    }
}
