package ru.yandex.stockpile.server.shard;

import javax.annotation.Nullable;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.memState.MetricIdAndData;

/**
 * MERGE TASK RESULT
 *
 * @author Stepan Koltsov
 */
public class MergeTaskResult implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(MergeTaskResult.class);

    private final MetricIdAndData currentLevel;
    private final MetricIdAndData nextLevel;

    public MergeTaskResult(MetricIdAndData current) {
        this(current, null);
    }

    public MergeTaskResult(@Nullable MetricIdAndData current, @Nullable MetricIdAndData next) {
        if (current == next) {
            throw new IllegalArgumentException(current + " == " + next);
        }
        this.currentLevel = current;
        this.nextLevel = next;
    }

    public MetricIdAndData getCurrentLevel() {
        return currentLevel;
    }

    public MetricIdAndData getNextLevel() {
        return nextLevel;
    }

    public long getRecordCount() {
        long records = 0;
        if (currentLevel != null) {
            records += currentLevel.archive().getRecordCount();
        }
        if (nextLevel != null) {
            records += nextLevel.archive().getRecordCount();
        }
        return records;
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        size += MemMeasurable.memorySizeOfNullable(currentLevel);
        size += MemMeasurable.memorySizeOfNullable(nextLevel);
        return size;
    }
}
