package ru.yandex.stockpile.server.shard;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.solomon.codec.archive.MetricArchiveGeneric;
import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.model.point.predicate.AggrPointPredicate;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.FilteringAggrGraphDataIterator;
import ru.yandex.solomon.model.timeseries.MetricTypeTransfers;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricArchives {
    private static final Logger logger = LoggerFactory.getLogger(MetricArchives.class);

    public static void typeSafeAppend(int shardId, long localId, MetricArchiveMutable target, MetricArchiveGeneric update) {
        typeSafeAppend(shardId, localId, target, update, AggrPointPredicate.TRUE);
    }

    public static void typeSafeAppend(int shardId, long localId, MetricArchiveMutable target, MetricArchiveGeneric update, AggrPointPredicate predicate) {
        try {
            MetricType targetType = target.getType();
            target.setDeleteBefore(update.getDeleteBefore());
            target.setOwnerProjectId(update.getOwnerProjectId());
            target.setOwnerShardId(update.getOwnerShardId());
            target.setDecimPolicyId(update.getDecimPolicyId());

            AggrGraphDataListIterator it = FilteringAggrGraphDataIterator.of(update.iterator(), predicate);
            if (targetType == MetricType.METRIC_TYPE_UNSPECIFIED) {
                target.setType(update.getType());
                target.ensureCapacity(it.columnSetMask(), update.bytesCount());
                target.addAllFrom(it);
            } else if (MetricTypeTransfers.isAvailableTransfer(targetType, update.getType())) {
                target.setType(update.getType());
                target.ensureCapacity(it.columnSetMask(), update.bytesCount());
                target.addAllFrom(it);
            } else if (update.getRecordCount() > 0) {
                logger.error("Not able to convert metric {} {} type from {} to {}, drop points {}",
                        target.header(),
                        StockpileMetricId.toString(shardId, localId),
                        targetType,
                        update.getType(),
                        update.getRecordCount());
            }
        } catch (Throwable e) {
            throw new RuntimeException("Failed append to metric "
                    + target.header() + " "
                    + StockpileMetricId.toString(shardId, localId)
                    + ", points "
                    + (update != null ? update.getRecordCount() : null),
                    e);
        }
    }
}
