package ru.yandex.stockpile.server.shard;

import java.util.concurrent.Flow;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class ProxyProcessor<T,R> implements Flow.Processor<T,R> {
    protected Flow.Subscription subscription;
    protected Flow.Subscriber<? super R> subscriber;

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        checkArgument(this.subscriber == null, this.subscriber);
        this.subscriber = subscriber;
        if (subscription != null) {
            this.subscriber.onSubscribe(subscription);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        checkArgument(this.subscription == null, this.subscription);
        this.subscription = subscription;
        if (subscriber != null) {
            this.subscriber.onSubscribe(subscription);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        subscriber.onComplete();
    }
}
