package ru.yandex.stockpile.server.shard;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
class ReadInProgress {
    final long readRangeFromMillis;
    final List<StockpileMetricReadRequest> reads = new ArrayList<>(1);

    ReadInProgress(long readRangeFromMillis, StockpileMetricReadRequest originalRequest) {
        this.readRangeFromMillis = readRangeFromMillis;
        this.reads.add(originalRequest);
    }

    long getLocalId() {
        return getInitRequest().getLocalId();
    }

    public StockpileMetricReadRequest getInitRequest() {
        return reads.get(0);
    }

    void addLateRead(StockpileMetricReadRequest readRequest) {
        if (getInitRequest().getFuture().isDone()) {
            throw new IllegalStateException();
        }

        if (readRequest.getLocalId() != getInitRequest().getLocalId()) {
            throw new IllegalStateException();
        }

        reads.add(readRequest);
    }

    void completeExceptionally(Throwable e) {
        for (StockpileMetricReadRequest request : reads) {
            request.getFuture().completeExceptionally(e);
        }
    }

    boolean isDone() {
        return getInitRequest().getFuture().isDone();
    }
}
