package ru.yandex.stockpile.server.shard;

import javax.annotation.Nonnull;

import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.MetricTypeTransfers;
import ru.yandex.solomon.model.timeseries.TimeFilterAggrGraphDataIterator;
import ru.yandex.stockpile.server.shard.cache.MetricSnapshot;

/**
 * @author Vladimir Gordiychuk
 */
final class ReadReply {

    static StockpileMetricReadResponse constructResponse(StockpileMetricReadRequest request, MetricSnapshot snapshot) {
        if (snapshot.header().getType() == MetricType.RATE) {
            var it = MetricTypeTransfers.of(MetricType.RATE, MetricType.DGAUGE, snapshot.iterator());
            return new StockpileMetricReadResponse(snapshot.header().withKind(MetricType.DGAUGE), AggrGraphDataArrayList.of(it));
        }
        return new StockpileMetricReadResponse(snapshot.header(), snapshot);
    }

    @Nonnull
    static StockpileMetricReadResponse constructResponse(
            StockpileMetricReadRequest request,
            MetricHeader header,
            AggrGraphDataListIterator it)
    {
        if (request.getFromMillis() != 0) {
            it = TimeFilterAggrGraphDataIterator.sliceFrom(it, request.getFromMillis());
        }

        if (request.getToMillis() != 0) {
            it = TimeFilterAggrGraphDataIterator.sliceTo(it, request.getToMillis());
        }

        if (header.getType() == MetricType.RATE) {
            it = MetricTypeTransfers.of(MetricType.RATE, MetricType.DGAUGE, it);
            return new StockpileMetricReadResponse(header.withKind(MetricType.DGAUGE), AggrGraphDataArrayList.of(it));
        }
        return new StockpileMetricReadResponse(header, AggrGraphDataArrayList.of(it));
    }
}
