package ru.yandex.stockpile.server.shard;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.stockpile.server.data.DeletedShardSet;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.command.SnapshotCommandContent;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotCommandMerger {

    private final SnapshotCommandLoader loader;

    public SnapshotCommandMerger(SnapshotCommandLoader loader) {
        this.loader = loader;
    }

    public CompletableFuture<SnapshotCommandContent> merge(List<SnapshotAddress> addresses) {
        final DeletedShardSet deletedShards = new DeletedShardSet();
        CompletableFuture<Void> future = completedFuture(null);
        for (var address : addresses) {
            future = future.thenCompose(ignore -> loader.readSnapshot(address))
                    .thenAccept(loaded -> {
                        if (loaded.isPresent()) {
                            var content = loaded.get().content();
                            mergeDeletedShards(deletedShards, content.deletedShards());
                        }
                    });
        }
        return future.thenApply(ignore -> new SnapshotCommandContent(deletedShards));
    }

    private static void mergeDeletedShards(DeletedShardSet target, DeletedShardSet source) {
        target.addAll(source);
    }
}
