package ru.yandex.stockpile.server.shard;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.command.LongFileTypeSnapshotCommand;
import ru.yandex.stockpile.server.data.command.SnapshotCommand;
import ru.yandex.stockpile.server.data.command.SnapshotCommandContent;
import ru.yandex.stockpile.server.shard.stat.SizeAndCount;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotCommandWriter {
    private final ShardThread shardThread;

    public SnapshotCommandWriter(ShardThread shardThread) {
        this.shardThread = shardThread;
    }

    public static boolean isWritable(boolean last, SnapshotCommandContent content) {
        return !content.isEmpty() && !StockpileFormat.CURRENT.lt(StockpileFormat.DELETED_SHARDS_39) && !last;
    }

    public CompletableFuture<SizeAndCount> write(SnapshotLevel level, long txn, SnapshotCommandContent content) {
        var command = new SnapshotCommand(level, txn, content);
        var serialized = LongFileTypeSnapshotCommand.I.serialize(command);
        var diskSize = new SizeAndCount(serialized.sumLength(), serialized.content().length);
        return shardThread.loopUntilSuccessFuture("writeCommandToTmp", () -> {
            return shardThread.shard.storage.writeSnapshotCommandToTemp(serialized);
        }).thenApply(ignore -> diskSize);
    }
}
