package ru.yandex.stockpile.server.shard;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;
import ru.yandex.stockpile.server.shard.stat.LevelSizeAndCount;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SnapshotIndexWithStats implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotIndexWithStats.class);
    @Nonnull
    private final SnapshotIndex index;
    private final LevelSizeAndCount diskSize;

    public SnapshotIndexWithStats(SnapshotIndex index, LevelSizeAndCount diskSize) {
        this.index = index;
        this.diskSize = diskSize;
    }

    public SnapshotAddress address() {
        return index.snapshotAddress();
    }

    @Nonnull
    public SnapshotIndex getIndex() {
        return index;
    }

    public boolean isReal() {
        return index.isReal();
    }

    public LevelSizeAndCount diskSize() {
        return diskSize;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + index.memorySizeIncludingSelf();
    }

    @Override
    public String toString() {
        return "SnapshotIndexWithStats{" +
            "index=" + index +
            ", idxSize=" + DataSize.shortString(diskSize.index().size()) +
            ", cnkSize=" + DataSize.shortString(diskSize.chunk().size()) +
            ", cmdSize=" + DataSize.shortString(diskSize.command().size()) +
            '}';
    }
}
