package ru.yandex.stockpile.server.shard;

import java.util.concurrent.CompletableFuture;

import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.index.LongFileTypeSnapshotIndex;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;
import ru.yandex.stockpile.server.data.index.SnapshotIndexContent;
import ru.yandex.stockpile.server.shard.stat.SizeAndCount;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotIndexWriter {
    private final ShardThread shardThread;

    public SnapshotIndexWriter(ShardThread shardThread) {
        this.shardThread = shardThread;
    }

    public static boolean isWritable(SnapshotIndexContent content) {
        return content.getMetricCount() > 0;
    }

    public CompletableFuture<SizeAndCount> write(SnapshotLevel level, long txn, SnapshotIndexContent content) {
        var index = new SnapshotIndex(level, txn, content);
        var serialized = LongFileTypeSnapshotIndex.I.serialize(index);
        var diskSize = new SizeAndCount(serialized.sumLength(), serialized.getContent().length);
        return shardThread.loopUntilSuccessFuture("writeIndexToTmp", () -> {
            return shardThread.shard.storage.writeSnapshotIndexToTemp(serialized);
        }).thenApply(ignore -> diskSize);
    }
}
