package ru.yandex.stockpile.server.shard;

import java.util.OptionalLong;

import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Stepan Koltsov
 */
public class SnapshotTs {
    private final long tsMillis;

    public enum SpecialTs {
        NOT_READY(-1),
        NEVER(-2),
        ;

        public final long value;

        SpecialTs(long value) {
            this.value = value;
        }
    }

    public SnapshotTs(SpecialTs specialTs) {
        this.tsMillis = specialTs.value;
    }

    public SnapshotTs(long tsMillis) {
        if (tsMillis != SpecialTs.NOT_READY.value && tsMillis != SpecialTs.NEVER.value) {
            InstantUtils.sanityCheckMillis(tsMillis);
        }
        this.tsMillis = tsMillis;
    }

    public boolean isNotReady() {
        return tsMillis == SpecialTs.NOT_READY.value;
    }

    public long getTsOrSpecial() {
        return tsMillis;
    }

    public OptionalLong getTsOrNever() {
        if (tsMillis == SpecialTs.NEVER.value) {
            return OptionalLong.empty();
        }
        if (tsMillis <= 0) {
            throw new IllegalStateException();
        }
        return OptionalLong.of(tsMillis);
    }

    @Override
    public String toString() {
        for (SpecialTs specialTs : SpecialTs.values()) {
            if (specialTs.value == tsMillis) {
                return specialTs.name();
            }
        }

        return InstantUtils.formatToMillis(tsMillis);
    }

    public String toStringToSeconds() {
        for (SpecialTs specialTs : SpecialTs.values()) {
            if (specialTs.value == tsMillis) {
                return specialTs.name();
            }
        }

        return InstantUtils.formatToSeconds(tsMillis);
    }
}
