package ru.yandex.stockpile.server.shard;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class StockpileMetricReadResponse {
    private final MetricHeader header;
    private final AggrGraphDataIterable timeseries;

    public StockpileMetricReadResponse(MetricHeader header, AggrGraphDataIterable timeseries) {
        this.header = header;
        this.timeseries = timeseries;
    }

    public MetricHeader getHeader() {
        return header;
    }

    public AggrGraphDataIterable getTimeseries() {
        return timeseries;
    }
}
