package ru.yandex.stockpile.server.shard;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.staffOnly.manager.ExtraContentParam;
import ru.yandex.solomon.staffOnly.manager.table.TableColumnDefImpl;
import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Stepan Koltsov
 */
public class StockpileShardExtra {
    static void extra(ExtraContentParam p, StockpileShardState state) {
        List<SnapshotIndexWithStats> indexes = state.indexesWithStatsUnsafe().collect(Collectors.toList());

        p.subh("Indexes");
        p.managerWriter().listTable(indexes,
            new TableColumnDefImpl<>("Lvl", i -> i.getIndex().getLevel().shortName),
            new TableColumnDefImpl<>("Txn", i -> i.getIndex().getTxn()),
            new TableColumnDefImpl<>("Ts", i -> InstantUtils.formatToMillis(i.getIndex().getContent().getTsMillis())),
            new TableColumnDefImpl<>("Reason", i -> i.getIndex().getContent().getSnapshotReason()),
            new TableColumnDefImpl<>("Fmt", i -> i.getIndex().getContent().getFormat().getFormat()),
            new TableColumnDefImpl<>("Disk", i ->
                    "idx: " + DataSize.shortString(i.diskSize().index().size())
                            + ", cnk: " + DataSize.shortString(i.diskSize().chunk().size())
                            + ", cmd: " + DataSize.shortString(i.diskSize().command().size())
            ),
            new TableColumnDefImpl<>("Chunks", i -> i.getIndex().getContent().getChunksCount()),
            new TableColumnDefImpl<>("Recs", i -> i.getIndex().getContent().getRecordCount())
        );
    }
}
