package ru.yandex.stockpile.server.shard;

import java.time.Clock;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.selfmon.executors.CpuMeasureExecutor;
import ru.yandex.stockpile.kikimrKv.counting.KikimrKvClientCounting;
import ru.yandex.stockpile.server.StockpileKvPersistenceContext;
import ru.yandex.stockpile.server.data.dao.ReadBatcher;
import ru.yandex.stockpile.server.shard.stat.GlobalUsageStats;
import ru.yandex.stockpile.server.shard.stat.StockpileShardAggregatedStats;

/**
 * @author Stepan Koltsov
 */
@Import({
    StockpileShardAggregatedStats.class,
    StockpileShardHacksForTest.class,
    MergeProcessMetrics.class,
    StockpileKvPersistenceContext.class,
    GlobalUsageStats.class,
    MergeContext.class,
})
@Configuration
public class StockpileShardGlobals {

    public final ExecutorService executorService;
    public final ScheduledExecutorService scheduledExecutorService;
    public final KikimrKvClientCounting kikimrKvClient;
    public final ReadBatcher readBatcher;
    public final StockpileShardAggregatedStats stockpileShardAggregatedStats;
    public final ExecutorService mergeExecutor;
    public final Executor stockpileReadExecutor;
    public final UpdateShardMemoryLimits updateShardMemoryLimits;
    public final StockpileShardHacksForTest stockpileShardHacksForTest;
    public final MergeProcessMetrics mergeProcessMetrics;
    public final GlobalUsageStats usage;
    public final MergeStrategy mergeStrategy;
    public final InvalidArchiveStrategy invalidArchiveStrategy;
    public final Clock clock;

    @Autowired
    public StockpileShardGlobals(
        @StockpileExecutor ExecutorService executorService,
        @StockpileScheduledExecutor ScheduledExecutorService scheduledExecutorService,
        KikimrKvClientCounting kikimrKvClient,
        ReadBatcher readBatcher,
        StockpileShardAggregatedStats stockpileShardAggregatedStats,
        @StockpileMergeExecutor ExecutorService mergeExecutor,
        @StockpileReadExecutor ExecutorService stockpileReadExecutor,
        UpdateShardMemoryLimits updateShardMemoryLimits,
        StockpileShardHacksForTest stockpileShardHacksForTest,
        MergeProcessMetrics mergeProcessMetrics,
        GlobalUsageStats globalUsageStats,
        MergeStrategy mergeStrategy,
        InvalidArchiveStrategy invalidArchiveStrategy,
        Clock clock)
    {
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.kikimrKvClient = kikimrKvClient;
        this.readBatcher = readBatcher;
        this.stockpileShardAggregatedStats = stockpileShardAggregatedStats;
        this.mergeExecutor = mergeExecutor;
        this.stockpileReadExecutor = new CpuMeasureExecutor(stockpileShardAggregatedStats.readUtime, stockpileReadExecutor);
        this.updateShardMemoryLimits = updateShardMemoryLimits;
        this.stockpileShardHacksForTest = stockpileShardHacksForTest;
        this.mergeProcessMetrics = mergeProcessMetrics;
        this.usage = globalUsageStats;
        this.mergeStrategy = mergeStrategy;
        this.invalidArchiveStrategy = invalidArchiveStrategy;
        this.clock = clock;
    }
}
