package ru.yandex.stockpile.server.shard;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
@Component
public class StockpileShardMetricSupplier implements MetricSupplier {
    private final StockpileLocalShards shards;

    public StockpileShardMetricSupplier(StockpileLocalShards shards) {
        this.shards = shards;
    }

    @Override
    public int estimateCount() {
        return 1000;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        StockpileShardMetrics total = new StockpileShardMetrics("total");
        for (StockpileShard shard : shards) {
            StockpileShardMetrics metrics = shard.metrics();
            metrics.append(tsMillis, commonLabels, consumer);
            total.combine(metrics);
        }

        total.append(tsMillis, commonLabels, consumer);
    }
}
