package ru.yandex.stockpile.server.shard;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Stream;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.memory.layout.MemMeasurableSubsystem;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.chunk.IndexRangeResult;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;
import ru.yandex.stockpile.server.data.index.stats.IndexStatsLevel;
import ru.yandex.stockpile.server.shard.actor.InActor;
import ru.yandex.stockpile.server.shard.stat.StockpileShardDiskStats;

/**
 * @author Stepan Koltsov
 */
abstract class StockpileShardState extends ShardThread implements MemMeasurableSubsystem {
    public StockpileShardState(StockpileShard shard) {
        super(shard);
    }

    @Override
    protected void stoppedReleaseResources() {
    }

    protected Stream<SnapshotIndex> indexesUnsafe() {
        return indexesWithStatsUnsafe().map(SnapshotIndexWithStats::getIndex);
    }

    protected abstract Stream<SnapshotIndexWithStats> indexesWithStatsUnsafe();

    public abstract StockpileShard.LoadState loadStateForMon();

    public String loadStateDescForMon() {
        return loadStateForMon().name();
    }

    public abstract StockpileShardDiskStats diskStats();

    public abstract OptionalInt snapshotCount(SnapshotLevel level);

    public IndexRangeResult rangeRequestsForMetric(InActor a, long localId, long fromMillis) {
        throw new IllegalStateException("wrong state: " + this);
    }

    public SnapshotTs latestStapshotTime(SnapshotLevel snapshotLevel) {
        return new SnapshotTs(SnapshotTs.SpecialTs.NOT_READY);
    }

    public IndexStatsLevel indexesStats() {
        return new IndexStatsLevel();
    }

    public long minRequiredMemory() {
        return 0;
    }

    public OptionalLong recordCountReliable() {
        return OptionalLong.empty();
    }

    public OptionalLong metricsCountReliable() {
        return OptionalLong.empty();
    }

    public Optional<StockpileFormat> oldestUsedFormatForMon() {
        return Optional.empty();
    }

    public void stop(InActor a) {
    }
}
