package ru.yandex.stockpile.server.shard;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.exception.RpcException;
import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.grpc.StockpileRuntimeException;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class StockpileShardStateException extends StockpileRuntimeException implements RpcException {
    public StockpileShardStateException(EStockpileStatusCode statusCode, String message) {
        super(statusCode, message);
    }

    @Override
    public boolean logOnRpcServer() {
        return false;
    }
}
