package ru.yandex.stockpile.server.shard;

import java.util.Comparator;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Vladimir Gordiychuk
 */
@Component
public class StockpileShardsHealthChecker implements OkProvider {
    private final StockpileLocalShards shards;

    public StockpileShardsHealthChecker(StockpileLocalShards shards) {
        this.shards = shards;
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return shards.stream()
            .sorted(Comparator.comparingInt(o -> o.shardId))
            .map(this::check)
            .toArray(Status[]::new);
    }

    private Status check(StockpileShard shard) {
        boolean ready = shard.isOk();
        String message = ready
            ? "shard " + StockpileShardId.toString(shard.shardId) + " ok"
            : "shard " + StockpileShardId.toString(shard.shardId) + " not ok";
        return new Status(StockpileShardsHealthChecker.class.getSimpleName(), ready, message);
    }
}
