package ru.yandex.stockpile.server.shard;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Vladimir Gordiychuk
 */
public class TxWriteSummary implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(TxWriteSummary.class);

    final long requests;
    final long metrics;
    final long records;
    final long bytes;

    public TxWriteSummary(long requests, long metrics, long records, long bytes) {
        this.requests = requests;
        this.metrics = metrics;
        this.records = records;
        this.bytes = bytes;
    }

    @Override
    public String toString() {
        return "TxWriteSummary{" +
            "requests=" + requests +
            ", metrics=" + metrics +
            ", records=" + records +
            ", bytes=" + bytes +
            '}';
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }
}
