package ru.yandex.stockpile.server.shard.actor;

/**
 * All possible types of runnables executed by stockpile shard actor
 *
 * @author Sergey Polovko
 */
public enum ActorRunnableType {
    COMPLETE_READ_OK(StockpileShardActState.RUNNABLE_COMPLETE_READ_OK),
    COMPLETE_READ_FAIL(StockpileShardActState.RUNNABLE_COMPLETE_READ_FAIL),
    COMPLETE_WRITE(StockpileShardActState.RUNNABLE_COMPLETE_WRITE),
    COMPLETE_LOG_SNAPSHOT(StockpileShardActState.RUNNABLE_COMPLETE_LOG_SNAPSHOT),
    FLUSH_CACHE(StockpileShardActState.RUNNABLE_FLUSH_CACHE),
    DONE_INIT(StockpileShardActState.RUNNABLE_DONE_INIT),
    DONE_LOGS_LOAD(StockpileShardActState.RUNNABLE_DONE_LOGS_LOAD),
    READ_METRICS_META(StockpileShardActState.RUNNABLE_READ_METRICS_META),
    READ_LOCAL_IDS(StockpileShardActState.RUNNABLE_READ_LOCAL_IDS),
    READ_CACHE_ENTRY(StockpileShardActState.RUNNABLE_READ_CACHE_ENTRY),
    MISC(StockpileShardActState.RUNNABLE_MISC),
    ;

    private final StockpileShardActState state;

    ActorRunnableType(StockpileShardActState state) {
        this.state = state;
    }

    public StockpileShardActState state() {
        return state;
    }
}
