package ru.yandex.stockpile.server.shard.cache;

import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.stockpile.server.shard.merge.AggrPointIteratorWrapper;
import ru.yandex.stockpile.server.shard.merge.Iterable;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricSnapshot implements AggrGraphDataIterable {
    private final MetricHeader header;
    private final Iterable source;
    private final Runnable releaseAction;

    public MetricSnapshot(MetricHeader header, Iterable source, Runnable releaseAction) {
        this.header = header;
        this.source = source;
        this.releaseAction = releaseAction;
    }

    public MetricHeader header() {
        return header;
    }

    @Override
    public int getRecordCount() {
        return source.elapsedRecords();
    }

    @Override
    public int elapsedBytes() {
        return source.elapsedBytes();
    }

    @Override
    public AggrGraphDataListIterator iterator() {
        return new AggrPointIteratorWrapper(source.iterator());
    }

    @Override
    public int columnSetMask() {
        return source.columnSetMask();
    }

    public void release() {
        releaseAction.run();
    }

    @Override
    public String toString() {
        return "MetricSnapshot{header=" + header + ", source=" + source + '}';
    }
}
