package ru.yandex.stockpile.server.shard.iter;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.kikimrKv.counting.ReadClass;
import ru.yandex.stockpile.server.data.chunk.ChunkAddressGlobal;
import ru.yandex.stockpile.server.data.chunk.ChunkWithNo;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.dao.StockpileShardStorage;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;
import ru.yandex.stockpile.server.shard.ShardThread;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SnapshotChunkIteratorPrefetch extends KvSnapshotChunkIterator {
    public static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotChunkIteratorPrefetch.class);

    private final StockpileShardStorage storage;
    private final ReadClass readClass;
    private final ShardThread mergeProcess;

    public SnapshotChunkIteratorPrefetch(StockpileShardStorage storage, ReadClass readClass, ShardThread mergeProcess, SnapshotAddress snapshotAddress, int chunkCount)
    {
        super(snapshotAddress, chunkCount);
        this.storage = storage;
        this.readClass = readClass;
        this.mergeProcess = mergeProcess;
    }

    @Override
    protected CompletableFuture<ChunkWithNo> readNext(SnapshotAddress snapshotAddress, int chunkNo) {
        Supplier<CompletableFuture<ChunkWithNo>> op = () -> {
            ChunkAddressGlobal chunkAddress = new ChunkAddressGlobal(snapshotAddress, chunkNo);
            return storage.readChunk(readClass, chunkAddress, FileNamePrefix.Current.instance)
                .thenApply(r -> new ChunkWithNo(chunkNo, r));
        };

        return mergeProcess.loopUntilSuccessFuture("prefetch:next", op);
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + super.memorySizeIncludingSelf();
    }
}
