package ru.yandex.stockpile.server.shard.load;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

/**
 * @author Vladimir Gordiychuk
 */
public class AsyncFnIterator<In, Out> implements AsyncIterator<Out> {
    private final Iterator<In> it;
    private final Function<In, CompletableFuture<Out>> fn;

    public AsyncFnIterator(Iterator<In> it, Function<In, CompletableFuture<Out>> fn) {
        this.it = it;
        this.fn = fn;
    }

    @Override
    public CompletableFuture<Out> next() {
        if (!it.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }

        return fn.apply(it.next());
    }
}
