package ru.yandex.stockpile.server.shard.load;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * @author Sergey Polovko
 */
public interface AsyncIterator<T> extends MemMeasurable {

    /**
     * Future completed with {@code null} is used as indicator of ended iterator.
     */
    CompletableFuture<T> next();

    @Override
    default long memorySizeIncludingSelf() {
        return MemoryCounter.OBJECT_HEADER_SIZE;
    }
}
