package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AggrPointIteratorWrapper extends AggrGraphDataListIterator {
    private final Iterator it;
    @Nullable
    private AggrGraphDataListIterator active;

    public AggrPointIteratorWrapper(Iterator it) {
        super(it.columnSetMask());
        this.it = it;
    }

    @Override
    public int estimatePointsCount() {
        return it.elapsedRecords();
    }

    @Override
    public boolean next(AggrPoint target) {
        while (true) {
            if (active == null) {
                var item = it.next();
                if (item == null) {
                    return false;
                }

                active = item.iterator();
            }

            if (active.next(target)) {
                return true;
            }

            active = null;
        }
    }
}
