package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.CompressStreamFactory;
import ru.yandex.solomon.codec.compress.frames.Frame;
import ru.yandex.solomon.codec.compress.frames.TimeSeriesFrameIterator;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class ClosedArchiveItemIterator implements Iterator {
    private final StockpileFormat format;
    private final MetricType type;
    private final int mask;
    private final int records;
    private final BitBuf compressed;

    private final TimeSeriesFrameIterator it;
    private final Frame frame;

    public ClosedArchiveItemIterator(StockpileFormat format, MetricType type, int mask, int records, BitBuf compressed) {
        this.format = format;
        this.type = type;
        this.mask = mask;
        this.records = records;
        this.compressed = compressed;
        this.it = CompressStreamFactory.createFrameIterator(compressed.asReadOnly());
        this.frame = new Frame();
    }

    public static Iterator of(StockpileFormat format, MetricType type, int mask, int records, BitBuf compressed) {
        if (records == 0) {
            return EmptyIterator.INSTANCE;
        }

        return new ClosedArchiveItemIterator(format, type, mask, records, compressed);
    }

    @Override
    public MetricType type() {
        return type;
    }

    @Override
    public int columnSetMask() {
        return mask;
    }

    @Override
    public int elapsedRecords() {
        return records;
    }

    @Nullable
    @Override
    public Item next() {
        if (!it.next(frame)) {
            return null;
        }

        if (!frame.closed) {
            throw new IllegalStateException("Frame not closed: " + frame);
        }

        return new ItemFrame(
            format,
            type,
            mask,
            frame.records,
            frame.firstTsMillis,
            frame.lastTsMillis,
            compressed.slice(frame.pos, frame.size)
        );
    }
}
