package ru.yandex.stockpile.server.shard.merge;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class ClosedArchiveIterable implements Iterable {
    private final StockpileFormat format;
    private final MetricType type;
    private final int mask;
    private final int records;
    private final BitBuf compressed;

    public ClosedArchiveIterable(StockpileFormat format, MetricType type, int mask, int records, BitBuf compressed) {
        this.format = format;
        this.type = type;
        this.mask = mask;
        this.records = records;
        this.compressed = compressed;
    }

    @Override
    public Iterator iterator() {
        return new ClosedArchiveItemIterator(format, type, mask, records, compressed);
    }

    @Override
    public int columnSetMask() {
        return mask;
    }

    @Override
    public int elapsedRecords() {
        return records;
    }

    @Override
    public int elapsedBytes() {
        return compressed.bytesSize();
    }
}
