package ru.yandex.stockpile.server.shard.merge;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class CompressResult {
    public final StockpileFormat format;
    public final MetricType type;
    public final int mask;
    public final BitBuf buffer;
    public final int records;
    public final long lastTsMillis;
    public final long frameCount;

    public CompressResult(StockpileFormat format, MetricType type, int mask, BitBuf buffer, int records, long lastTsMillis, long frameCount) {
        this.format = format;
        this.type = type;
        this.mask = mask;
        this.buffer = buffer;
        this.records = records;
        this.lastTsMillis = lastTsMillis;
        this.frameCount = frameCount;
    }

    public MetricArchiveImmutable getArchive(MetricHeader header) {
        return new MetricArchiveImmutable(header, format, mask, buffer, records);
    }
}
