package ru.yandex.stockpile.server.shard.merge;

import ru.yandex.solomon.model.timeseries.decim.DecimPolicy;

/**
 * @author Vladimir Gordiychuk
 */
public class DecimIterable implements Iterable {
    private final Iterable source;
    private final DecimPolicy policy;
    private final long now;
    private final long decimatedAt;

    public DecimIterable(Iterable source, DecimPolicy policy, long now, long decimatedAt) {
        this.source = source;
        this.policy = policy;
        this.now = now;
        this.decimatedAt = decimatedAt;
    }

    @Override
    public Iterator iterator() {
        return DecimIterator.of(source.iterator(), policy, now, decimatedAt);
    }

    @Override
    public int columnSetMask() {
        return source.columnSetMask();
    }

    @Override
    public int elapsedRecords() {
        return source.elapsedRecords();
    }

    @Override
    public int elapsedBytes() {
        return source.elapsedBytes();
    }
}
