package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.FilteringAfterAggrGraphDataIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleteAfterIterator implements Iterator {
    private final long deleteAfterMillis;
    private final Iterator it;

    public DeleteAfterIterator(long deleteAfterMillis, Iterator it) {
        this.deleteAfterMillis = deleteAfterMillis;
        this.it = it;
    }

    @Override
    public MetricType type() {
        return it.type();
    }

    @Override
    public int columnSetMask() {
        return it.columnSetMask();
    }

    @Override
    public int elapsedRecords() {
        return it.elapsedRecords();
    }

    @Nullable
    @Override
    public Item next() {
        var item = it.next();
        if (item == null) {
            return null;
        }

        if (item.getLastTsMillis() < deleteAfterMillis) {
            return item;
        }

        if (item.getFirstTsMillis() >= deleteAfterMillis) {
            return null;
        }

        var it = new FilteringAfterAggrGraphDataIterator(item.iterator(), deleteAfterMillis);
        return new ItemIterator(
            it,
            item.getFirstTsMillis(),
            Math.min(item.getLastTsMillis(), deleteAfterMillis),
            item.getElapsedBytes());
    }
}
