package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.FilteringBeforeAggrGraphDataIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleteBeforeIterator implements Iterator {
    private final long deleteBeforeMillis;
    private final Iterator it;

    public DeleteBeforeIterator(long deleteBeforeMillis, Iterator it) {
        this.deleteBeforeMillis = deleteBeforeMillis;
        this.it = it;
    }

    public static Iterator of(long deleteBeforeMillis, Iterator it) {
        if (deleteBeforeMillis == 0) {
            return it;
        } else if (deleteBeforeMillis == 1) {
            return EmptyIterator.INSTANCE;
        } else {
            return new DeleteBeforeIterator(deleteBeforeMillis, it);
        }
    }

    @Override
    public MetricType type() {
        return it.type();
    }

    @Override
    public int columnSetMask() {
        return it.columnSetMask();
    }

    @Override
    public int elapsedRecords() {
        return it.elapsedRecords();
    }

    @Nullable
    @Override
    public Item next() {
        while (true) {
            var item = it.next();
            if (item == null) {
                return null;
            }

            if (item.getFirstTsMillis() >= deleteBeforeMillis) {
                return item;
            }

            if (item.getLastTsMillis() < deleteBeforeMillis) {
                continue;
            }

            var it = new FilteringBeforeAggrGraphDataIterator(item.iterator(), deleteBeforeMillis);
            return new ItemIterator(
                it,
                Math.max(item.getFirstTsMillis(), deleteBeforeMillis),
                item.getLastTsMillis(),
                item.getElapsedBytes());
        }
    }
}
