package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class EmptyIterator implements Iterator {
    public static final Iterator INSTANCE = new EmptyIterator();
    private final int mask;

    public EmptyIterator() {
        this.mask = 0;
    }

    public EmptyIterator(int columnSetMask) {
        this.mask = columnSetMask;
    }

    @Override
    public MetricType type() {
        return MetricType.METRIC_TYPE_UNSPECIFIED;
    }

    @Override
    public int columnSetMask() {
        return mask;
    }

    @Override
    public int elapsedRecords() {
        return 0;
    }

    @Nullable
    @Override
    public Item next() {
        return null;
    }
}
