package ru.yandex.stockpile.server.shard.merge;

/**
 * @author Vladimir Gordiychuk
 */
public class FilterAfterIterable implements Iterable {
    private final Iterable iterable;
    private final long afterTsMillis;

    public FilterAfterIterable(Iterable iterable, long afterTsMillis) {
        this.iterable = iterable;
        this.afterTsMillis = afterTsMillis;
    }

    @Override
    public Iterator iterator() {
        return new DeleteAfterIterator(afterTsMillis, iterable.iterator());
    }

    @Override
    public int columnSetMask() {
        return iterable.columnSetMask();
    }

    @Override
    public int elapsedRecords() {
        return iterable.elapsedRecords();
    }

    @Override
    public int elapsedBytes() {
        return iterable.elapsedBytes();
    }
}
