package ru.yandex.stockpile.server.shard.merge;

/**
 * @author Vladimir Gordiychuk
 */
public class FilterBeforeIterable implements Iterable {
    private final Iterable iterable;
    private final long beforeTsMillis;

    public FilterBeforeIterable(Iterable iterable, long beforeTsMillis) {
        this.iterable = iterable;
        this.beforeTsMillis = beforeTsMillis;
    }

    @Override
    public Iterator iterator() {
        return new DeleteBeforeIterator(beforeTsMillis, iterable.iterator());
    }

    @Override
    public int columnSetMask() {
        return iterable.columnSetMask();
    }

    @Override
    public int elapsedRecords() {
        return iterable.elapsedRecords();
    }

    @Override
    public int elapsedBytes() {
        return iterable.elapsedBytes();
    }
}
