package ru.yandex.stockpile.server.shard.merge;

import java.time.Instant;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.model.point.column.StockpileColumnSet;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class ItemIterator implements Item {
    private final AggrGraphDataListIterator iterator;
    private final long firstTsMillis;
    private final long lastTsMillis;
    private final int elapsedBytes;

    public ItemIterator(AggrGraphDataListIterator iterator, long firstTsMillis, long lastTsMillis, int elapsedBytes) {
        this.iterator = iterator;
        this.firstTsMillis = firstTsMillis;
        this.lastTsMillis = lastTsMillis;
        this.elapsedBytes = elapsedBytes;
    }

    @Override
    public long getFirstTsMillis() {
        return firstTsMillis;
    }

    @Override
    public long getLastTsMillis() {
        return lastTsMillis;
    }

    @Override
    public int getElapsedBytes() {
        return elapsedBytes;
    }

    @Override
    public AggrGraphDataListIterator iterator() {
        return iterator;
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "ItemIterator{" +
            "mask=" + StockpileColumnSet.toString(iterator.columnSetMask()) +
            ", record=" + DataSize.shortString(iterator.estimatePointsCount()) +
            ", firstTsMillis=" + Instant.ofEpochMilli(firstTsMillis) +
            ", lastTsMillis=" + Instant.ofEpochMilli(lastTsMillis) +
            ", bytes=" + DataSize.shortString(elapsedBytes) +
            '}';
    }
}
