package ru.yandex.stockpile.server.shard.merge;

import java.util.List;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class MergeIterable implements Iterable {
    private final List<Iterable> sources;

    private MergeIterable(List<Iterable> sources) {
        this.sources = sources;
    }

    public static Iterable of(List<Iterable> sources) {
        return new MergeIterable(sources);
    }

    @Override
    public Iterator iterator() {
        return sources.stream()
            .map(Iterable::iterator)
            .collect(collectingAndThen(toList(), MergeIterator::of));
    }

    @Override
    public int columnSetMask() {
        int mask = 0;
        for (var source : sources) {
            mask |= source.columnSetMask();
        }
        return mask;
    }

    @Override
    public int elapsedRecords() {
        int records = 0;
        for (var source : sources) {
            records += source.elapsedRecords();
        }
        return records;
    }

    @Override
    public int elapsedBytes() {
        int size = 0;
        for (var source : sources) {
            size += source.elapsedBytes();
        }
        return size;
    }
}
